<?php
// import_medicines.php - Bulk import Ghana NHIS Medicines into products table

// Load DB connection config; adjust path if needed
require_once __DIR__ . '/../config/config.php';

// Array of all medicine parts files to include and process
$batch_files = [
    'full_gh_nhis_medicines_2025_part1.php',
    'full_gh_nhis_medicines_2025_part2.php',
    'full_gh_nhis_medicines_2025_part3.php',
    'full_gh_nhis_medicines_2025_part4.php',
    'full_gh_nhis_medicines_2025_part5.php',
    'full_gh_nhis_medicines_2025_part6.php',
    'full_gh_nhis_medicines_2025_part7.php',
    'full_gh_nhis_medicines_2025_part8.php',
    'full_gh_nhis_medicines_2025_part9.php',
    'full_gh_nhis_medicines_2025_part10.php',
    'full_gh_nhis_medicines_2025_part11.php',
    'full_gh_nhis_medicines_2025_part12.php',
    'full_gh_nhis_medicines_2025_part13.php',
];

// Connect to DB
$conn = getDbConnection();
if (!$conn) {
    die("Failed to connect to DB: " . mysqli_connect_error());
}

foreach ($batch_files as $file) {
    // Load the batch file which populates $products array
    require __DIR__ . '/' . $file;

    foreach ($products as $prod) {
        // Destructure medicine details
        [$code, $name, $unit, $price] = $prod;
        $category = "Medicines";

        // Prepare Insert with update on duplicate using barcode as unique key
        $stmt = $conn->prepare("
            INSERT INTO products 
                (barcode, product_name, unit, price, category, stock_quantity, branch_id) 
            VALUES (?, ?, ?, ?, ?, 0, NULL) 
            ON DUPLICATE KEY UPDATE 
                price = VALUES(price),
                product_name = VALUES(product_name),
                unit = VALUES(unit),
                category = VALUES(category)
        ");
        if (!$stmt) {
            die("Prepare failed: " . $conn->error);
        }
        $stmt->bind_param("sssds", $code, $name, $unit, $price, $category);

        if (!$stmt->execute()) {
            echo "Failed to import product barcode {$code}: " . $stmt->error . PHP_EOL;
        }
        $stmt->close();
    }

    // Clear products array before loading next batch
    unset($products);
}

echo "All Ghana NHIS Medicines List parts imported successfully." . PHP_EOL;
?>
