<?php
session_start();
require_once "../includes/role_helpers.php";
requireAdmin();
require_once "../config/config.php";

$conn = getDbConnection();

$success_msg = $error_msg = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $product_id = intval($_POST['product_id'] ?? 0);
    $alternative_id = intval($_POST['alternative_id'] ?? 0);

    if ($product_id > 0 && $alternative_id > 0 && $product_id != $alternative_id) {
        // Prevent duplicate entry
        $stmt_check = $conn->prepare("SELECT 1 FROM alternative_drugs WHERE product_id = ? AND alternative_id = ?");
        $stmt_check->bind_param("ii", $product_id, $alternative_id);
        $stmt_check->execute();
        $stmt_check->store_result();
        if ($stmt_check->num_rows == 0) {
            $stmt_check->close();
            $stmt = $conn->prepare("INSERT INTO alternative_drugs (product_id, alternative_id) VALUES (?, ?)");
            $stmt->bind_param("ii", $product_id, $alternative_id);
            $stmt->execute();
            $stmt->close();
            $success_msg = "Alternative drug added.";
        } else {
            $error_msg = "This alternative drug pairing already exists.";
            $stmt_check->close();
        }
    } else {
        $error_msg = "Select valid different products.";
    }
}

if (isset($_GET['delete'])) {
    $del_id = intval($_GET['delete']);
    $stmt = $conn->prepare("DELETE FROM alternative_drugs WHERE id = ?");
    $stmt->bind_param("i", $del_id);
    $stmt->execute();
    $stmt->close();
    $success_msg = "Alternative drug deleted.";
}

// Fetch alternative drugs list with join
$sql = "
    SELECT ad.id, p.product_name, a.product_name AS alternative_name
    FROM alternative_drugs ad
    JOIN products p ON ad.product_id = p.product_id
    JOIN products a ON ad.alternative_id = a.product_id
    ORDER BY p.product_name
";
$altDrugs = $conn->query($sql);

// Fetch products for dropdown
$products = $conn->query("SELECT product_id, product_name FROM products ORDER BY product_name");

$conn->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <title>Alternative Drugs - Admin</title>
    <link rel="stylesheet" href="css/bootstrap.min.css" />
    <style>.container{max-width:800px;margin:30px auto;}</style>
</head>
<body>
<div class="container">
    <h2>Alternative Drugs Management</h2>
    <?php if ($success_msg): ?><div class="alert alert-success"><?= htmlspecialchars($success_msg) ?></div><?php endif; ?>
    <?php if ($error_msg): ?><div class="alert alert-danger"><?= htmlspecialchars($error_msg) ?></div><?php endif; ?>

    <form method="post" class="form-inline mb-4">
        <select name="product_id" class="form-control mr-3" required>
            <option value="">Select Product</option>
            <?php while ($prod = $products->fetch_assoc()): ?>
                <option value="<?= $prod['product_id'] ?>"><?= htmlspecialchars($prod['product_name']) ?></option>
            <?php endwhile; ?>
        </select>
        <?php
            // Re-fetch $products result for second dropdown (reset pointer)
            $products->data_seek(0);
        ?>
        <select name="alternative_id" class="form-control mr-3" required>
            <option value="">Select Alternative</option>
            <?php while ($prod = $products->fetch_assoc()): ?>
                <option value="<?= $prod['product_id'] ?>"><?= htmlspecialchars($prod['product_name']) ?></option>
            <?php endwhile; ?>
        </select>

        <button type="submit" class="btn btn-primary">Add Alternative</button>
    </form>

    <table class="table table-bordered table-striped">
        <thead><tr><th>Product</th><th>Alternative</th><th>Action</th></tr></thead>
        <tbody>
        <?php while ($row = $altDrugs->fetch_assoc()): ?>
            <tr>
                <td><?= htmlspecialchars($row['product_name']) ?></td>
                <td><?= htmlspecialchars($row['alternative_name']) ?></td>
                <td>
                    <a href="?delete=<?= $row['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Delete this alternative drug?');">Delete</a>
                </td>
            </tr>
        <?php endwhile; ?>
        </tbody>
    </table>
</div>
</body>
</html>
