<?php
require_once "../config/config.php";
session_start();
require_once "../includes/role_helpers.php";
requireAdmin();
$conn = getDbConnection();

$message = "";
$error = "";

// Fetch products and branches to populate dropdowns
$products = $conn->query("SELECT product_id, product_name FROM products ORDER BY product_name");
$branches = $conn->query("SELECT branch_id, branch_name FROM branches ORDER BY branch_name");

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $product_id = intval($_POST['product_id']);
    $branch_id = intval($_POST['branch_id']);
    $quantity = intval($_POST['quantity']);
    $notes = trim($_POST['notes']);

    if ($product_id <= 0 || $branch_id <= 0 || $quantity <= 0) {
        $error = "Please select valid product, branch and enter a positive quantity.";
    } else {
        // Update stock_quantity in products table (or stock table if separate implementation)
        $stmt = $conn->prepare("UPDATE products SET stock_quantity = stock_quantity + ? WHERE product_id = ?");
        $stmt->bind_param("ii", $quantity, $product_id);

        if ($stmt->execute()) {
            // Log this stock addition event if you have audit or stock logs (optional)
            $message = "Inventory updated successfully.";
        } else {
            $error = "Failed to update inventory: " . $stmt->error;
        }
        $stmt->close();
    }
}
$conn->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <title>Add Inventory Stock - Adwenpa Pharma</title>
    <meta charset="UTF-8" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
</head>
<body>
<div class="container my-4">
    <h2>Add Inventory Stock</h2>
    <?php if ($message): ?>
        <div class="alert alert-success"><?= htmlspecialchars($message) ?></div>
    <?php endif; ?>
    <?php if ($error): ?>
        <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
    <?php endif; ?>

    <form method="post">
        <div class="mb-3">
            <label for="product_id" class="form-label">Product</label>
            <select name="product_id" id="product_id" class="form-select" required>
                <option value="" disabled selected>Select Product</option>
                <?php while($row = $products->fetch_assoc()): ?>
                    <option value="<?= $row['product_id'] ?>"><?= htmlspecialchars($row['product_name']) ?></option>
                <?php endwhile; ?>
            </select>
        </div>

        <div class="mb-3">
            <label for="branch_id" class="form-label">Branch</label>
            <select name="branch_id" id="branch_id" class="form-select" required>
                <option value="" disabled selected>Select Branch</option>
                <?php while($row = $branches->fetch_assoc()): ?>
                    <option value="<?= $row['branch_id'] ?>"><?= htmlspecialchars($row['branch_name']) ?></option>
                <?php endwhile; ?>
            </select>
        </div>

        <div class="mb-3">
            <label for="quantity" class="form-label">Quantity</label>
            <input type="number" name="quantity" id="quantity" min="1" class="form-control" required />
        </div>

        <div class="mb-3">
            <label for="notes" class="form-label">Notes (optional)</label>
            <textarea name="notes" id="notes" class="form-control"></textarea>
        </div>

        <button type="submit" class="btn btn-primary">Add to Inventory</button>
        <a href="stock_management.php" class="btn btn-secondary ms-2">Back to Stock Management</a>
    </form>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
