<?php
session_start();
require_once __DIR__ . "/../config/config.php";
require_once "../includes/role_helpers.php";
requireAdmin();

$conn = getDbConnection();

$success_message = "";
if (isset($_GET["success"])) {
    $success_message = $_GET["success"];
}

$result = $conn->query("SELECT user_id, username, full_name, email, role FROM users ORDER BY user_id DESC");
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <title>User Management - Admin</title>
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
    <style>
        body {
            min-height: 100vh;
            display: flex;
            flex-direction: column;
        }

        .sidebar {
            height: 100vh;
            position: fixed;
            top: 0;
            left: 0;
            width: 220px;
            background-color: #0d6efd;
            color: white;
            padding-top: 60px;
            flex-shrink: 0;
            z-index: 1040;
        }

        .sidebar a {
            display: block;
            color: white;
            text-decoration: none;
            padding: 15px 25px;
            font-weight: 500;
            transition: background-color 0.3s ease;
        }

        .sidebar a.active,
        .sidebar a:hover {
            background-color: #084298;
            color: white;
            text-decoration: none;
        }

        main.content {
            margin-left: 220px;
            padding: 40px 30px 30px 30px;
            margin-top: 70px;
            flex-grow: 1;
            background: #f8f9fa;
            min-height: calc(100vh - 70px);
        }

        h2 {
            margin-bottom: 30px;
        }

        .table thead th {
            background-color: #0d6efd;
            color: white;
            border-color: #0d6efd;
        }

        .btn-primary {
            box-shadow: 0 4px 6px rgba(13, 110, 253, 0.3);
            transition: all 0.2s ease;
        }

        .btn-primary:hover {
            background-color: #0b5ed7;
            box-shadow: 0 6px 12px rgba(13, 110, 253, 0.45);
        }

        .btn-warning {
            background-color: #ffc107;
            border-color: #ffc107;
            color: #212529;
            transition: all 0.2s ease;
        }

        .btn-warning:hover {
            background-color: #e0a800;
            border-color: #d39e00;
            color: #212529;
        }

        .btn-danger {
            transition: all 0.2s ease;
        }

        .btn-danger:hover {
            box-shadow: 0 4px 10px rgba(220, 53, 69, 0.6);
        }
    </style>
</head>
<body>
    <!-- Sidebar -->
    <div class="sidebar d-none d-lg-block">
        <a href="dashboard.php">Dashboard</a>
        <a href="manage_users.php" class="active">Manage Users</a>
        <a href="inventory.php">Inventory</a>
        <a href="reports.php">Reports</a>
    </div>

    <!-- Main Content -->
    <main class="content">
        <h2>User Management</h2>
        <?php if ($success_message): ?>
            <div class="alert alert-success"><?= htmlspecialchars($success_message) ?></div>
        <?php endif; ?>
        <a href="add_user.php" class="btn btn-primary mb-4">Add New User</a>
        <div class="table-responsive">
            <table class="table table-bordered table-hover table-striped align-middle">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Username</th>
                        <th>Full Name</th>
                        <th>Email</th>
                        <th>Role</th>
                        <th class="text-center" style="width: 140px;">Actions</th>
                    </tr>
                </thead>
                <tbody>
                <?php while ($user = $result->fetch_assoc()): ?>
                    <tr>
                        <td><?= htmlspecialchars($user['user_id']) ?></td>
                        <td><?= htmlspecialchars($user['username']) ?></td>
                        <td><?= htmlspecialchars($user['full_name']) ?></td>
                        <td><?= htmlspecialchars($user['email']) ?></td>
                        <td><?= htmlspecialchars(ucfirst($user['role'])) ?></td>
                        <td class="text-center">
                            <a href="edit_user.php?id=<?= $user['user_id'] ?>" class="btn btn-sm btn-warning" title="Edit User">
                                <i class="bi bi-pencil-square"></i> Edit
                            </a>
                            <a href="delete_user.php?id=<?= $user['user_id'] ?>" class="btn btn-sm btn-danger"
                               onclick="return confirm('Are you sure to delete this user?');" title="Delete User">
                                <i class="bi bi-trash"></i> Delete
                            </a>
                        </td>
                    </tr>
                <?php endwhile; ?>
                </tbody>
            </table>
        </div>
    </main>

    <!-- Bootstrap Bundle with Popper for dropdowns, tooltips -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <!-- Bootstrap Icons CDN -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-icons/1.13.0/font/bootstrap-icons.min.css" rel="stylesheet" />
</body>
</html>
<?php $conn->close(); ?>
