<?php
require_once "../config/config.php";

header('Content-Type: application/json');

if (!isset($_GET['barcode'])) {
    echo json_encode(['success' => false, 'message' => 'Missing barcode']);
    exit;
}

$barcode = $_GET['barcode'];

$conn = getDbConnection();

$stmt = $conn->prepare("SELECT product_id FROM products WHERE barcode = ? LIMIT 1");
$stmt->bind_param("s", $barcode);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    echo json_encode(['success' => false, 'message' => 'Product not found']);
} else {
    $row = $result->fetch_assoc();
    echo json_encode(['success' => true, 'product_id' => $row['product_id']]);
}

$stmt->close();
$conn->close();
