<?php
require_once "../config/config.php";
session_start();
require_once "../includes/role_helpers.php";
requireLogin();

$conn = getDbConnection();

$prescription_id = $_GET['id'] ?? null;
$editing = false;
$patient_name = '';
$prescription_date = date('Y-m-d');
$notes = '';

if ($prescription_id) {
    // Fetch existing prescription
    $stmt = $conn->prepare("SELECT patient_name, prescription_date, notes FROM prescriptions WHERE prescription_id = ?");
    $stmt->bind_param('i', $prescription_id);
    $stmt->execute();
    $result = $stmt->get_result();
    if ($result->num_rows === 0) {
        header('Location: manage_prescriptions.php');
        exit;
    }
    $prescription = $result->fetch_assoc();
    $patient_name = $prescription['patient_name'];
    $prescription_date = $prescription['prescription_date'];
    $notes = $prescription['notes'];
    $editing = true;
    $stmt->close();
}

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $patient_name = trim($_POST['patient_name']);
    $prescription_date = $_POST['prescription_date'];
    $notes = trim($_POST['notes']);
    $sales_rep_id = $_SESSION['user_id'];

    if ($editing) {
        // Update
        $stmt = $conn->prepare("UPDATE prescriptions SET patient_name = ?, prescription_date = ?, notes = ?, sales_rep_id = ? WHERE prescription_id = ?");
        $stmt->bind_param('sssii', $patient_name, $prescription_date, $notes, $sales_rep_id, $prescription_id);
        $success = $stmt->execute();
        $stmt->close();
    } else {
        // Insert
        $stmt = $conn->prepare("INSERT INTO prescriptions (patient_name, prescription_date, notes, sales_rep_id) VALUES (?, ?, ?, ?)");
        $stmt->bind_param('sssi', $patient_name, $prescription_date, $notes, $sales_rep_id);
        $success = $stmt->execute();
        $stmt->close();
    }

    if ($success) {
        header("Location: manage_prescriptions.php");
        exit;
    } else {
        $error = "Database error: " . $conn->error;
    }
}

$conn->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <title><?= $editing ? 'Edit' : 'Add' ?> Prescription - Adwenpa Pharma</title>
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
</head>
<body>

<nav class="navbar navbar-expand-lg navbar-dark bg-primary">
    <div class="container-fluid">
        <a href="dashboard.php" class="navbar-brand">Adwenpa Pharma</a>
    </div>
</nav>

<div class="container my-4">
    <a href="manage_prescriptions.php" class="btn btn-secondary mb-3">&larr; Back to Prescriptions</a>
    
    <h2><?= $editing ? 'Edit' : 'Add' ?> Prescription</h2>

    <?php if (!empty($error)): ?>
    <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
    <?php endif; ?>

    <form method="post" novalidate>
        <div class="mb-3">
            <label for="patient_name" class="form-label">Patient Name</label>
            <input type="text" name="patient_name" id="patient_name" required class="form-control" value="<?= htmlspecialchars($patient_name) ?>" />
        </div>

        <div class="mb-3">
            <label for="prescription_date" class="form-label">Prescription Date</label>
            <input type="date" name="prescription_date" id="prescription_date" required class="form-control" value="<?= htmlspecialchars($prescription_date) ?>" />
        </div>

        <div class="mb-3">
            <label for="notes" class="form-label">Notes</label>
            <textarea name="notes" id="notes" rows="6" class="form-control"><?= htmlspecialchars($notes) ?></textarea>
        </div>

        <button type="submit" class="btn btn-primary"><?= $editing ? 'Update' : 'Add' ?> Prescription</button>
    </form>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
