<?php
require_once "../config/config.php";
session_start();
require_once "../includes/role_helpers.php";
requireAdmin();
$conn = getDbConnection();

$action = $_GET['action'] ?? '';

// Fetch branches for branch selection
$branches = $conn->query("SELECT branch_id, branch_name FROM branches ORDER BY branch_name");

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $supplier_id = intval($_POST['supplier_id']);
    $order_date = $_POST['order_date'];
    $status = $_POST['status'] ?? 'Pending';
    $branch_id = intval($_POST['branch_id']); // Branch selected in form

    if ($action === 'create') {
        // Insert purchase order with branch_id
        $stmt = $conn->prepare("INSERT INTO purchase_orders (supplier_id, order_date, status, branch_id) VALUES (?, ?, ?, ?)");
        $stmt->bind_param("issi", $supplier_id, $order_date, $status, $branch_id);
        $stmt->execute();
        $po_id = $stmt->insert_id;
        $stmt->close();

        // Insert purchase order items referencing product_id
        if (!empty($_POST['products']) && !empty($_POST['quantities']) && !empty($_POST['unit_prices'])) {
            $stmt_item = $conn->prepare("INSERT INTO po_items (po_id, product_id, quantity, unit_price) VALUES (?, ?, ?, ?)");
            foreach ($_POST['products'] as $idx => $product_id) {
                $quantity = intval($_POST['quantities'][$idx]);
                $unit_price = floatval($_POST['unit_prices'][$idx]);
                if ($quantity > 0) {
                    $stmt_item->bind_param("iiid", $po_id, $product_id, $quantity, $unit_price);
                    $stmt_item->execute();
                }
            }
            $stmt_item->close();
        }

        header("Location: purchase_orders.php");
        exit;
    }
}

// Fetch suppliers for dropdown
$suppliers = $conn->query("SELECT supplier_id, name FROM suppliers ORDER BY name");

// Fetch products with barcode for selection
$products = $conn->query("SELECT product_id, product_name, barcode, price FROM products ORDER BY product_name");

// Fetch purchase orders with supplier and branch name
$purchase_orders = $conn->query("
    SELECT po.*, s.name as supplier_name, b.branch_name
    FROM purchase_orders po
    JOIN suppliers s ON po.supplier_id = s.supplier_id
    JOIN branches b ON po.branch_id = b.branch_id
    ORDER BY po.order_date DESC
");

$conn->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <title>Purchase Orders - Adwenpa Pharma</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
    <script>
      function addProductRow() {
          const table = document.getElementById('productsTable');
          const row = table.insertRow();
          let html = `<td>
              <select name="products[]" class="form-select" required>
                  <option value="" disabled selected>Select product</option>
                  <?php 
                  $products->data_seek(0);
                  while($p = $products->fetch_assoc()): ?>
                      <option value="<?= $p['product_id'] ?>"><?= htmlspecialchars($p['product_name']) ?> (<?= htmlspecialchars($p['barcode']) ?>)</option>
                  <?php endwhile; ?>
              </select>
          </td>
          <td><input type="number" name="quantities[]" min="1" value="1" class="form-control" required></td>
          <td><input type="number" name="unit_prices[]" min="0" step="0.01" value="0" class="form-control" required></td>
          <td><button type="button" onclick="this.closest('tr').remove()" class="btn btn-danger">Remove</button></td>`;
          row.innerHTML = html;
      }
    </script>
</head>
<body>
<div class="container my-4">
    <h2>Purchase Orders</h2>

    <h4>Create New Purchase Order</h4>
    <form method="post" action="purchase_orders.php?action=create" class="mb-4">
        <div class="mb-3">
            <label for="supplier_id" class="form-label">Supplier</label>
            <select id="supplier_id" name="supplier_id" class="form-select" required>
                <option value="" disabled selected>Select supplier</option>
                <?php while($row = $suppliers->fetch_assoc()): ?>
                <option value="<?= $row['supplier_id'] ?>"><?= htmlspecialchars($row['name']) ?></option>
                <?php endwhile; ?>
            </select>
        </div>
        <div class="mb-3">
            <label for="branch_id" class="form-label">Branch</label>
            <select id="branch_id" name="branch_id" class="form-select" required>
                <option value="" disabled selected>Select branch</option>
                <?php while ($branch = $branches->fetch_assoc()): ?>
                    <option value="<?= $branch['branch_id'] ?>"><?= htmlspecialchars($branch['branch_name']) ?></option>
                <?php endwhile; ?>
            </select>
        </div>
        <div class="mb-3">
            <label for="order_date" class="form-label">Order Date</label>
            <input type="date" name="order_date" id="order_date" class="form-control" required value="<?= date('Y-m-d') ?>" />
        </div>
        <div class="mb-3">
            <label class="form-label">Products</label>
            <table class="table" id="productsTable">
                <thead><tr><th>Product</th><th>Quantity</th><th>Unit Price</th><th>Action</th></tr></thead>
                <tbody>
                    <tr>
                        <td>
                            <select name="products[]" class="form-select" required>
                                <option value="" disabled selected>Select product</option>
                                <?php 
                                $products->data_seek(0);
                                while($p = $products->fetch_assoc()): ?>
                                <option value="<?= $p['product_id'] ?>"><?= htmlspecialchars($p['product_name']) ?> (<?= htmlspecialchars($p['barcode']) ?>)</option>
                                <?php endwhile; ?>
                            </select>
                        </td>
                        <td><input type="number" name="quantities[]" min="1" value="1" class="form-control" required></td>
                        <td><input type="number" name="unit_prices[]" min="0" step="0.01" value="0" class="form-control" required></td>
                        <td><button type="button" onclick="this.closest('tr').remove()" class="btn btn-danger">Remove</button></td>
                    </tr>
                </tbody>
            </table>
            <button type="button" onclick="addProductRow()" class="btn btn-secondary">Add Product</button>
        </div>

        <button type="submit" class="btn btn-primary">Create Purchase Order</button>
    </form>

    <h4>Existing Purchase Orders</h4>
    <table class="table table-striped">
        <thead>
            <tr><th>PO ID</th><th>Supplier</th><th>Branch</th><th>Order Date</th><th>Status</th><th>Actions</th></tr>
        </thead>
        <tbody>
            <?php foreach ($purchase_orders as $po): ?>
                <tr>
                    <td><?= $po['po_id'] ?></td>
                    <td><?= htmlspecialchars($po['supplier_name']) ?></td>
                    <td><?= htmlspecialchars($po['branch_name']) ?></td>
                    <td><?= $po['order_date'] ?></td>
                    <td><?= $po['status'] ?></td>
                    <td>
                        <a href="view_purchase_order.php?id=<?= $po['po_id'] ?>" class="btn btn-sm btn-info">Details</a>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
