<?php
session_start();
require_once "../includes/role_helpers.php";
requireSalesRep();
require_once "../config/config.php";

$conn = getDbConnection();

$sale_message = "";
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $product_id = intval($_POST['product_id'] ?? 0);
    $quantity = intval($_POST['quantity'] ?? 0);

    if ($product_id > 0 && $quantity > 0) {
        // Insert sale record logic here (simplified example)
        $stmt = $conn->prepare("INSERT INTO sales (user_id, product_id, quantity, sale_date) VALUES (?, ?, ?, NOW())");
        $stmt->bind_param("iii", $_SESSION['user_id'], $product_id, $quantity);
        if ($stmt->execute()) {
            $sale_message = "Sale recorded successfully.";
        } else {
            $sale_message = "Error recording sale.";
        }
        $stmt->close();
    } else {
        $sale_message = "Please select product and enter quantity.";
    }
}

// Fetch product list
$products_result = $conn->query("SELECT product_id, product_name, price FROM products ORDER BY product_name");

$conn->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <title>Sales Portal - Adwenpa Pharma</title>
    <link rel="stylesheet" href="css/bootstrap.min.css" />
    <style>.container{max-width:600px;margin:30px auto;}</style>
</head>
<body>
<div class="container">
    <h2>Sales Entry</h2>
    <?php if ($sale_message): ?>
        <div class="alert alert-info"><?= htmlspecialchars($sale_message) ?></div>
    <?php endif; ?>

    <form method="post" action="sales.php">
        <div class="form-group">
            <label for="product_id">Product</label>
            <select name="product_id" class="form-control" required>
                <option value="">Select a product</option>
                <?php while ($product = $products_result->fetch_assoc()): ?>
                    <option value="<?= $product['product_id'] ?>"><?= htmlspecialchars($product['product_name']) ?> (<?= number_format($product['price'], 2) ?>)</option>
                <?php endwhile; ?>
            </select>
        </div>
        <div class="form-group">
            <label for="quantity">Quantity</label>
            <input type="number" name="quantity" class="form-control" min="1" required />
        </div>
        <button type="submit" class="btn btn-primary">Record Sale</button>
    </form>
</div>
</body>
</html>
