<?php
session_start();

// Redirect logged-in users to dashboard
if (isset($_SESSION['loggedin']) && $_SESSION['loggedin'] === true) {
    header('Location: dashboard.php');
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <title>Welcome to Adwenpa Pharma</title>
    <link rel="stylesheet" href="css/bootstrap.min.css" />
    <style>
        body { font-family: Arial, sans-serif; background-color: #f8f9fa; }
        .hero {
            background-color: #007bff;
            color: white;
            padding: 80px 20px;
            text-align: center;
        }
        .features {
            padding: 40px 20px;
        }
        .feature-item {
            margin-bottom: 30px;
        }
        .btn-primary {
            background-color: #0069d9;
            border-color: #0062cc;
        }
    </style>
</head>
<body>

<div class="hero">
    <h1>Welcome to Adwenpa Pharma</h1>
    <p>Your trusted pharmacy point-of-sale and management solution.</p>
    <a href="login.php" class="btn btn-light btn-lg mr-3">Login</a>
    <a href="register.php" class="btn btn-outline-light btn-lg">Register</a>
</div>

<div class="container features">
    <h2 class="text-center mb-5">Key Features</h2>
    <div class="row">
        <div class="col-md-4 feature-item text-center">
            <h4>Efficient Sales Processing</h4>
            <p>Quickly record sales with real-time inventory updates.</p>
        </div>
        <div class="col-md-4 feature-item text-center">
            <h4>Prescription Management</h4>
            <p>Handle prescriptions securely with detailed records.</p>
        </div>
        <div class="col-md-4 feature-item text-center">
            <h4>User Role Access</h4>
            <p>Distinct roles for admins and sales reps with controlled access.</p>
        </div>
    </div>
</div>

<div class="text-center py-4">
    <small>&copy; 2025 Adwenpa Pharma. All rights reserved.</small>
</div>

</body>
</html>
